#!/usr/bin/env python
# -*- coding: utf-8 -*-

from os import listdir
import subprocess


def main():
    paths = {"js": "static/js/",
             "css": "static/css/"}
    
    def get_files(path, ext):
        return (f for f in listdir(path)
                if f.endswith("." + ext) and
                not f.endswith(".min." + ext))
    
    def compress_file(path, filename, ext):
        print("Compressing {}...".format(filename))
        output_file = "{}{}.min.{}".format(
            path, filename[:-len(ext) - 1], ext)
        cmd = "java -jar yuicompressor-2.4.8.jar -o {} {}".format(
            output_file, path + filename)
        subprocess.call(cmd)
        print("Done.")
    
    for ext, path in paths.items():
        files = get_files(path, ext)
        for filename in files:
            compress_file(path, filename, ext)


if __name__ == "__main__":
    main()
